define([
    'underscore',
    'marionette',
    'Vent',
    'User',

    'modules/appointments/messages/request-message',

    'text!modules/appointments/requested/request-new-message-form.html',
    'text!modules/appointments/messages/_request-new-message-textarea.html',
], function(
    _,
    Marionette,
    vent,
    User,
    
    Message,
    
    template,
    _textareaTemplate
) {
    'use strict';

    return Marionette.View.extend({
        tagName: 'form',
        template: _.template(template),
        ui: {
            sendMessage: '#send-message-btn',
            newMessage: '#new-message',
        },
        events: {
            'click #send-message-btn': 'sendMessage',
            'keyup #new-message': 'validateNewMessageAndUpdateCounter',
        },
        // serialize model only
        serializeData: function() {
            var data = {};

            if (this.model) {
                data = this.model.toJSON();
            }

            return data;
        },
        sendMessage: function(e) {
            var message;
            var mlength;
            
            if (!this.sendMessageAllowed) {
                return;
            }
            message = this.ui.newMessage.val().trim();
            mlength = message.length;
            
            this.disableSend(true);

            if (mlength <= 0 || mlength > this.ui.newMessage.attr('maxlength')) {
                return;
            }

            this._sendAppointmentMessage({message: message, request: this.model});
            this.ui.newMessage.val('');

            // set focus to modal-content-section header
            $('#request-messages').focus();
        },
        _sendAppointmentMessage: function(config) {
            var self = this;
            var message = config.message;
            var request = config.request;
            var messageModel = {};
            var url;
            
            messageModel.messageText = message;
            // This ternary is needed for messages because of the two ways to access the details page of a request.
            // 1. through submission of a request.
            // 2. Through clicking on a request from the list.
            // eslint-disable-next-line max-len
            messageModel.AppointmentRequestId = (!_.isEmpty(request.get('dataIdentifier'))) ? request.get('dataIdentifier').uniqueId : request.get('appointmentRequestId');
            messageModel.senderId = User.get('id');

            url = request.get('links')
                .get('appointment-request-messages')
                .get('href');

            new Message().save(messageModel, {
                url: url,
                success: function (resp) {
                    self.collection.fetch({
                        url: url,
                        reset: true,
                    });
                },
            });
        },
        getValWithCarriageReturns: function(el) {
            // jQuery's $.val() strips carriage returns from count
            return el ? el.value.replace(/\r(?!\n)|\n(?!\r)/g, '\r\n') : '';
        },
        validateNewMessageAndUpdateCounter: function(e) {
            // update counter AND enforce the limit set by maxlength, since ~IE9 does not honor maxlength
            var $textarea = this.ui.newMessage;
            var val = this.getValWithCarriageReturns(this.ui.newMessage.get(0));
            var maxLength = parseInt($textarea.attr('maxlength'), 10);
            var counter;
            
            if (val.length > 0) {
                if (val.length > maxLength) {
                    $textarea.val(val.substring(0, maxLength));
                }
            }
            
            counter = (maxLength <= val.length ? 0 : (maxLength - val.length)) + ' characters remaining';
            this.$el.find('.textarea-counter').html(counter);
            this.disableSend($textarea.val().trim().length === 0);
        },

        // eslint-disable-next-line complexity
        allowVeteranToSendMessage: function() {
            /*
                No messages allowed after:
                (a) Appointment Date has passed
                (b) Appointment has been cancelled
                (c) BusinessDays rule
            */

            var request = this.model;
            var initiating = false;
            var vetLastMessage = false;
            var lastMessage = null;
            var today = new Date();
            var oneYear = new Date().setFullYear(new Date().getFullYear() + 1);
            var appointmentDate = new Date(request.get('appointmentDate') || oneYear);
            var dayOfWeek = appointmentDate.getDay();

            // eslint-disable-next-line no-magic-numbers
            var considerWeekend = dayOfWeek === 1 ? 2 : 0;

            // eslint-disable-next-line max-len
            var oneBusinessDaysBefore = new Date(new Date(appointmentDate).setDate(appointmentDate.getDate() - considerWeekend));

            // eslint-disable-next-line max-len
            var twoBusinessDaysBefore = new Date(new Date(appointmentDate).setDate(appointmentDate.getDate() - considerWeekend - 1));

            // eslint-disable-next-line max-len
            var placeholder = 'Messages (100 characters max) should not be used for cancelling an appointment or for clinical questions that may need provider attention.';
            var disabled = false;

            today.setHours(0);
            today.setMinutes(0);
            today.setSeconds(0);
            today.setMilliseconds(0);

            if (request.get('status') === 'Cancelled' ||
                today.getTime() > appointmentDate.getTime()) {
                disabled = true;
            } else if (lastMessage) {
                if (vetLastMessage) {
                    if (initiating && today.getTime() > twoBusinessDaysBefore.getTime()) {
                        placeholder = 'Please Call. Two business days required to initiate a message';
                        disabled = true;
                    } else if (
                        !initiating &&
                        today.getTime() >= oneBusinessDaysBefore.getTime() &&
                        today.getTime() <= appointmentDate.getTime()
                    ) {
                        placeholder = 'Please Call. One business day required to respond to a message';
                        disabled = true;
                    }
                }
            }

            if (request.get('hasVeteranNewMessage')) {
                this.clearNewMessageFlag();
            }

            this.ui.newMessage.val('').prop({
                placeholder: placeholder,
                disabled: disabled,
            });
            return !disabled;
        },
        clearNewMessageFlag: function() {
            this.model.set('hasVeteranNewMessage', false);
            $.ajax({
                type: 'POST',
                url: this.model.get('links')
                    .get('appointment-request-new-message-flag')
                    .get('href'),
                data: '{}',
                contentType: 'application/json; charset=utf-8',
            });
        },
        vetCreatedMessage: function(message) {
            return message.get('senderId') === User.get('id');
        },
        disableSend: function(state) {
            if (this.ui.sendMessage.length > 0) {
                this.ui.sendMessage[0].disabled = state;
            }
        },
        onAttach: function() {
            this.$el.trigger('create');
            this.disableSend(true);
            this.sendMessageAllowed = this.allowVeteranToSendMessage();
        },
        templateContext: {newMessageTextarea: _.template(_textareaTemplate)},
    });
});
